#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("ggplot2")
#install.packages("ggpubr")


#library packages
library(limma)
library(ggplot2)
library(ggpubr)

pFilter=1                      #pvalue filter
groupFile="metabolismcluster.txt"           #group file
drugFile="DrugPredictions.csv"     #Drug Sensitivity file
setwd("E:\\metabolism\\LGG\\16.ANN_validation\\Rembrandt\\6.drugsens\\pRRophetic")     

#read group file
group=read.table(groupFile, header=T, sep="\t", check.names=F, row.names=1)

#read Drug Sensitivity file
senstivity=read.csv(drugFile, header=T, sep=",", check.names=F, row.names=1)
colnames(senstivity)=gsub("(.*)\\_(\\d+)", "\\1", colnames(senstivity))

#data merge
sameSample=intersect(row.names(group), row.names(senstivity))
group=group[sameSample, "group",drop=F]
senstivity=senstivity[sameSample,,drop=F]
rt=cbind(group, senstivity)

#Set up the comparison group
rt$group=factor(rt$group, levels=c("C1", "C2"))
type=levels(factor(rt[,"group"]))
comp=combn(type, 2)
my_comparisons=list()
for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}

#Loop the drug and draw a boxplot
for(drug in colnames(rt)[2:ncol(rt)]){
	rt1=rt[,c(drug, "group")]
	colnames(rt1)=c("Drug", "group")
	rt1=na.omit(rt1)
	#Difference analysis
	test=wilcox.test(Drug ~ group, data=rt1)
	diffPvalue=test$p.value
	#plot
	if(diffPvalue<pFilter){
		boxplot=ggboxplot(rt1, x="group", y="Drug", fill="group",
					      xlab="",
					      ylab=paste0(drug, " predicted IC50"),
					      legend.title="metabolismcluster",
					      palette=c("#435E97", "#E7C169")
					     )+ 
			stat_compare_means(comparisons=my_comparisons)
		#output
		pdf(file=paste0("drugSenstivity.", drug, ".pdf"), width=4.5, height=4)
		print(boxplot)
		dev.off()
	}
}

